% ALPHA ENGINE DEFINITION
% Generated 25-Sep-2023 09:23:28

% SUGGESTED CITATION:
% VW 1.5L TSI evo Hybrid Concept 4 Engine from 2019 Aachen Paper - ALPHA Map Package. Version 2023-09. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2023.


% Constructor
engine = class_REVS_engine();
engine.name =  'VW 1.5L TSI evo Hybrid Concept 4 Engine from 2019 Aachen Paper'; 
engine.source_filename = mfilename;
engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  1.5; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  15; 
engine.bore_mm =  74.5; 
engine.stroke_mm =  85.9; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	     0.0000000000000000	;     86.584924878581461	;     104.45306647121383	;     127.92167030952929	;     158.05749119675107	;     175.65894408857764	;     210.06178382217320	;     231.13018956267589	;     250.33177455461757	;     418.34564307702743	;     458.88232251027762	;     481.82643863579153	;     504.77055476130545		]; 
engine.full_throttle_torque_Nm = [	     0.0000000000000000	;     75.678392000000002	;     98.994975000000011	;     121.30653250000000	;     160.90452249999998	;     177.98994950000002	;     205.32663350000001	;     217.78894500000001	;     220.20100500000001	;     220.60301500000000	;     214.17085400000002	;     183.57501771428574	;     0.0000000000000000		]; 
engine.naturally_aspirated_speed_radps = [	     0.0000000000000000	;     504.77055476130545		]; 
engine.naturally_aspirated_torque_Nm = [	     107.42958658702935	    107.42958658702935		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	     0.0000000000000000	;     504.77055476130545	;     733.03828583761833		]; 
engine.closed_throttle_torque_Nm = [	    -11.963636363636365	;    -26.298382881204969	;    -30.940805307063979		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	     0.0000000000000000	;     24.054479271641839	;     48.108958543283677	;     72.163437814925516	;     96.217917086567354	;     110.17646365311489	;     120.68053745272778	;     137.03244055371584	;     147.98511843379339	;     162.07921113770038	;     180.55593949186317	;     194.24962774891236	;     199.23117348274479	;     215.80439287180440	;     232.54366385964704	;     238.13321366514725	;     252.29912211889246	;     269.71046559213073	;     290.99923581968289	;     309.70105563145296	;     322.26440450117832	;     335.07956774501201	;     351.72608097568400	;     375.08858063138382	;     399.25939424953697	;     415.76236111005107	;     433.28718350433974	;     450.24998535205691	;     455.05270636115267	;     465.31383902216760	;     504.77055476130545		]; 
engine.fuel_map_torque_Nm = [	    -34.163181818181819	;    -7.8890442805194816	;     18.385093257142856	;     33.605260749999999	;     42.293850979166663	;     50.982441208333327	;     58.528427982758629	;     66.912857631944433	;     76.551467944444454	;     84.119684616071424	;     93.088071166666651	;     102.94732440624999	;     110.70234099999999	;     117.56781862500000	;     128.78643099999999	;     134.24749144999998	;     141.11854344444441	;     146.98996679999999	;     153.54515060000000	;     159.86622083333333	;     164.43701233333334	;     168.56187299999999	;     172.57525100000001	;     177.25752499999999	;     181.54960966666667	;     185.17279833333333	;     189.91081383333332	;     193.47826087499999	;     198.36120390000002	;     207.98274960526314	;     215.21739114285714	;     218.00445966666666	;     231.63316575000002		]; 
engine.fuel_map_gps = [
 -0.013470711871005516	 -0.050717806339553875	 -0.075851523200629142	 -0.091143702677884519	  -0.10610966180609954	  -0.11459170205906875	  -0.12089243570599727	  -0.13051570822728020	  -0.13679671863444126	  -0.14467391737452293	  -0.15446894839443071	  -0.16127155670528462	  -0.16368345390889547	  -0.17141797495430888	  -0.17843561777734365	  -0.18064510239328066	  -0.18597023350145331	  -0.19159046245975025	  -0.19665794291436450	  -0.19935796340203288	  -0.20045690437741961	  -0.20111059919283469	  -0.20118663078679261	  -0.19951869775586945	  -0.19580225432211390	  -0.19260262162105060	  -0.18886106574609898	  -0.18502108830196781	  -0.18391938057346197	  -0.18155297697786979	  -0.17207166522987355	;
-0.0054135206332446475	-0.00015917502054225890	  0.017548658153042847	  0.034778858574703551	  0.051169350993615963	  0.060248760677516541	  0.066930159327304548	  0.077041074074657531	  0.083630951569610076	  0.091956488134437353	   0.10274790802741376	   0.11094712727360902	   0.11398909793541151	   0.12442401632169023	   0.13591111752951479	   0.13989360182679336	   0.15029040053212550	   0.16404524718142474	   0.18291622691579862	   0.20195310440465705	   0.21602648678775824	   0.23124357108031821	   0.25233818719005358	   0.28494227222111224	   0.32268058808632760	   0.35031116066303175	   0.38087417686779484	   0.41137736392220037	   0.42007890055842201	   0.43872648869076381	   0.51206812335391449	;
 0.0035862922301682135	  0.054200574348820370	   0.10450387131860149	   0.15406800237908719	   0.20243986313471535	   0.23041867318293277	   0.25156087233441277	   0.28399676769880428	   0.30420742038583304	   0.32862021594983881	   0.35877559139871196	   0.38140930145785285	   0.38990778698988909	   0.41971966683513662	   0.45355581967061076	   0.46525495651425014	   0.49565044973533978	   0.53326852847813788	   0.57806879945790746	   0.61827980179393471	   0.64856606138437101	   0.68043389909670460	   0.72079995462972102	   0.77411348944984082	   0.83257833954423832	   0.88015441380128923	   0.93861945560208204	   0.99914926163101692	    1.0162831505733276	    1.0526596637186372	    1.1824024900909718	;
  0.019023142257654758	  0.085999739073689851	   0.15256500854742097	   0.21800695295872746	   0.28193967724312746	   0.31894595539900861	   0.34654180285057445	   0.38794540076186407	   0.41460755887325668	   0.44836118248272849	   0.49213611604506496	   0.52511184527638299	   0.53721511983359038	   0.57807697239324740	   0.62140265758862800	   0.63645758224836591	   0.67572391499207263	   0.72691263925758154	   0.79250386150794727	   0.84866715870045040	   0.88624152948058077	   0.92544907197913773	   0.97842521358059187	    1.0557099688918175	    1.1358056017424503	    1.1948539608263593	    1.2616133751691576	    1.3282971268819337	    1.3474744338769640	    1.3883640443300866	    1.5393691412148582	;
  0.030193668394441459	   0.10496135731202304	   0.17966788142729126	   0.25383591224857988	   0.32559629335956564	   0.36627524007026502	   0.39642441349271001	   0.44194953389510166	   0.47142928722897359	   0.50858615022800546	   0.55683547088930052	   0.59366899448492405	   0.60728523859521144	   0.65363087744630566	   0.70323709932978362	   0.72025785855158020	   0.76429051292359218	   0.82072857396985899	   0.89235371939583530	   0.95672047559717555	    1.0009131161167899	    1.0468657763361737	    1.1081726945459112	    1.1974636337004418	    1.2925942444284539	    1.3602358768079736	    1.4339780646074112	    1.5070086434988483	    1.5278835373923623	    1.5723960818339588	    1.7398106721391500	;
  0.043666004550805840	   0.12494991901665130	   0.20622108838675762	   0.28711201777969125	   0.36662839419266136	   0.41179261812095846	   0.44532145778691723	   0.49637779851895769	   0.52949646001085759	   0.57092399704000596	   0.62374465394541312	   0.66532597053333153	   0.68085420239192196	   0.73417343584189476	   0.79053119780300052	   0.80966473861339683	   0.85879729133706217	   0.92095287476802279	   0.99872858889499627	    1.0692015739264951	    1.1182222813994049	    1.1701976374095051	    1.2396250613915292	    1.3396633701068914	    1.4449631094069546	    1.5194705451415784	    1.6009789615806851	    1.6814796393998308	    1.7043239570641768	    1.7531532211428940	    1.9401209597308910	;
  0.057969629116935123	   0.14393484480510960	   0.22989324241705555	   0.31574975558415302	   0.40133768464035524	   0.45076004948700832	   0.48779852980207827	   0.54496311001707365	   0.58270749043071435	   0.63065118167856438	   0.69205487584501579	   0.73936147584023892	   0.75695239437492701	   0.81707589526403934	   0.88005515312392268	   0.90123820462767712	   0.95517566124424913	    1.0222777765679663	    1.1060654973897841	    1.1821302046591926	    1.2347779008742361	    1.2900728568643347	    1.3637850093070065	    1.4705825866162354	    1.5808356428606307	    1.6596181797590726	    1.7481438826677655	    1.8351394182988252	    1.8597796100777748	    1.9124228523155447	    2.1154208986441221	;
  0.077455893671968118	   0.16786470383673577	   0.25835240147214461	   0.34913299599977460	   0.44078601274629037	   0.49479980693118619	   0.53562337944354643	   0.59898018886995497	   0.64137774139513914	   0.69638130139249010	   0.76941438670190698	   0.82476723552303222	   0.84510651340306175	   0.91351183900563393	   0.98339731748866888	    1.0068071680122976	    1.0663101723217971	    1.1404492494360998	    1.2338734871951540	    1.3191055637479492	    1.3770202891746026	    1.4361808759014201	    1.5135848350944177	    1.6254782275001771	    1.7434782227836132	    1.8274762911989340	    1.9210660255693857	    2.0124867075580535	    2.0384504983915717	    2.0940194753198256	    2.3131947678897959	;
   0.10647600119698454	   0.20146610409988147	   0.29680232132678819	   0.39316391291398539	   0.49160122439679316	   0.55023101373358474	   0.59493006151279437	   0.66558372675822308	   0.71382459042736968	   0.77687282057704532	   0.86082549100875616	   0.92334986516593431	   0.94610505619153595	    1.0218553457691568	    1.0988497594750937	    1.1247306142658582	    1.1907853955128254	    1.2739900634930423	    1.3789989263923619	    1.4732457077133445	    1.5370057731178217	    1.6022148525922362	    1.6873272290881465	    1.8091639216230264	    1.9393476483981305	    2.0307083836367390	    2.1300661617901229	    2.2278138600575192	    2.2554822264209928	    2.3146391799219894	    2.5472460547327347	;
   0.13500239387141913	   0.23363025280763602	   0.33277281349357846	   0.43355954869532115	   0.53752230912792354	   0.59922264616239884	   0.64677057664891091	   0.72324115506907760	   0.77566240745392678	   0.84407345679658796	   0.93489032473131584	    1.0021346829874080	    1.0265485491252704	    1.1076522733873146	    1.1904227644987271	    1.2182945108137861	    1.2895300499976081	    1.3793849948219998	    1.4924624998100291	    1.5932959229973340	    1.6614759893520867	    1.7312347538816102	    1.8223306663931222	    1.9512221747665284	    2.0877316049177743	    2.1858661360107718	    2.2935546252571681	    2.3989331691391373	    2.4285689833194746	    2.4917351290479193	    2.7368036301178629	;
   0.17560020414483210	   0.27895527751395754	   0.38278899872801841	   0.48828036169356359	   0.59750661254881154	   0.66343540601811457	   0.71438740579279725	   0.79653235764734287	   0.85295621351318107	   0.92660906461586401	    1.0240146439276783	    1.0963043322082904	    1.1226387576057559	    1.2105154523279931	    1.3006692633887973	    1.3310517357564886	    1.4086230110240980	    1.5056984255496724	    1.6270068507797339	    1.7352784777104022	    1.8085557199563731	    1.8836204514100092	    1.9816300240438371	    2.1197310575588633	    2.2642653888996458	    2.3693209167598503	    2.4869347675858671	    2.6033262081226800	    2.6361232263310739	    2.7059858667261905	    2.9669896579070993	;
   0.22989708981482140	   0.33949981343810298	   0.44941718572633549	   0.56058293972490914	   0.67504824722658296	   0.74403883193226061	   0.79710127525040642	   0.88238547360404962	   0.94125882195973332	    1.0185837361149839	    1.1216035838623604	    1.1995025098207586	    1.2280454425211056	    1.3238875802788830	    1.4223962350350821	    1.4554993422536471	    1.5397870258084221	    1.6445010915497873	    1.7745187912639224	    1.8906112862497737	    1.9693493726621019	    2.0501641962827857	    2.1560369785559326	    2.3073130652981027	    2.4698131062412840	    2.5856228402588526	    2.7123422520535678	    2.8363462784856006	    2.8710312585185287	    2.9447011914971468	    3.2231471197482109	;
   0.27863005160887888	   0.39393004716830554	   0.50952106193515168	   0.62604781602777004	   0.74466114118922466	   0.81498273521343434	   0.86856180223558854	   0.95343455057010884	    1.0119476953815671	    1.0898878880083205	    1.1978718704836249	    1.2809776818570919	    1.3114698374270506	    1.4138930719442295	    1.5185423289298734	    1.5535522361036902	    1.6423968976323413	    1.7523318191320723	    1.8890203243219286	    2.0116181747746960	    2.0949627229078454	    2.1806306497895345	    2.2933313592826607	    2.4560694089116555	    2.6318642867121134	    2.7552999259403625	    2.8882380688510918	    3.0172147315534104	    3.0535146642108555	    3.1308307440837706	    3.4265625905286461	;
   0.32495011375782334	   0.44561123893221538	   0.56657808465827331	   0.68827918131520127	   0.81093045749808612	   0.88228375329399078	   0.93602199501414407	    1.0200677838123582	    1.0778552597805262	    1.1555572737756841	    1.2675516783810381	    1.3545927746282929	    1.3865670094458720	    1.4940774489243034	    1.6036932521944707	    1.6401670834649447	    1.7322491249433560	    1.8462303413263557	    1.9889406568468111	    2.1176926566762728	    2.2053692978963206	    2.2954916107870629	    2.4143830642178998	    2.5873038376255071	    2.7739782517692806	    2.9035628073626225	    3.0420480156907490	    3.1763544312705219	    3.2143753971968936	    3.2956005897732794	    3.6079451320759102	;
   0.40708175181688472	   0.53685600188687799	   0.66686247164790202	   0.79731263813381681	   0.92814051133171549	    1.0040172513412289	    1.0610548821051820	    1.1496560870909149	    1.2087456323611849	    1.2847940010879961	    1.3934430509305884	    1.4806603902718964	    1.5131089806203701	    1.6239353010267430	    1.7387209123677738	    1.7770503038666026	    1.8742871514475266	    1.9957109696053186	    2.1487503937677515	    2.2876072021508906	    2.3827273864982264	    2.4810356182743676	    2.6110947524881203	    2.7998861808562934	    3.0021959889535030	    3.1415977972850855	    3.2905096727948653	    3.4356074997613693	    3.4767861742064579	    3.5648584033929662	    3.9066695381721446	;
   0.44843042977184855	   0.58265857407968524	   0.71705817800750293	   0.85178718421724198	   0.98683496729767395	    1.0652198248894735	    1.1241553503030859	    1.2155990228952533	    1.2761979556305814	    1.3529217457869465	    1.4582569616477770	    1.5439120968401956	    1.5759181463944327	    1.6859871872652306	    1.8027891013295443	    1.8422415327985466	    1.9429850553253221	    2.0689464851444508	    2.2272404465573894	    2.3707724560449965	    2.4691967060940425	    2.5710073564789653	    2.7057872852608136	    2.9012735626519262	    3.1108007657468804	    3.2556713546456257	    3.4105425774174223	    3.5616818654576767	    3.6045907645682451	    3.6963733107630272	    4.0524274259805271	;
   0.50088863602357658	   0.64076854987820009	   0.78073262195921989	   0.92087087809234458	    1.0611980878752303	    1.1426083008493140	    1.2037944465208670	    1.2986618000445751	    1.3614583244830127	    1.4408033578991009	    1.5428432565369350	    1.6263388322234575	    1.6576993155193356	    1.7666924107905086	    1.8866662748676566	    1.9274424980403428	    2.0319065053987004	    2.1628403597158274	    2.3272193013474038	    2.4764796302285630	    2.5784698990534523	    2.6843093835713150	    2.8245220306879251	    3.0279986236186214	    3.2464738395709389	    3.3983616057806922	    3.5612597226284262	    3.7203873238116572	    3.7656072682070514	    3.8623277391671320	    4.2355048116224205	;
   0.54546718698245378	   0.69032737846646142	   0.83518380596519959	   0.98001344780249477	    1.1247192759842888	    1.2084885402845933	    1.2713703166413823	    1.3687142710235405	    1.4331256914071813	    1.5147470713171245	    1.6172470645124803	    1.7014794056384570	    1.7331762624159213	    1.8433744004265089	    1.9648874126373972	    2.0062962930494397	    2.1125916396119826	    2.2464556409460044	    2.4210865776035986	    2.5760435338457501	    2.6808622549742145	    2.7882930199060501	    2.9287405545797545	    3.1367993316187874	    3.3630870075974659	    3.5209113993488992	    3.6905513367892069	    3.8565305277446393	    3.9036897787817746	    4.0045328912690081	    4.3906417025709175	;
   0.59436290126742419	   0.74506588390696815	   0.89565061134863388	    1.0458923807987563	    1.1954347951917119	    1.2817196936279429	    1.3464022281879930	    1.4463880316709397	    1.5124791782353193	    1.5962302928333831	    1.7023972187984719	    1.7894047983279995	    1.8222132479247086	    1.9362840109427031	    2.0594026211028300	    2.1012081724891289	    2.2084185599433144	    2.3457797266193121	    2.5268470372145062	    2.6878411470765848	    2.7968624823651891	    2.9086663163513955	    3.0549164299977560	    3.2625783096109902	    3.4951338683866804	    3.6592210299218060	    3.8357618833184954	    4.0085268216515813	    4.0575734697638959	    4.1624226666133319	    4.5613916769864140	;
   0.63990219775569435	   0.79667917511575759	   0.95322275929079436	    1.1090789960915328	    1.2635790599043883	    1.3524258972289367	    1.4189633232968721	    1.5218112044857091	    1.5899936280945777	    1.6767056138208754	    1.7867687029860062	    1.8771827958043501	    1.9113473595552224	    2.0299408589536565	    2.1556554273255131	    2.1979226877756051	    2.3057812278365097	    2.4428042418620324	    2.6298445264216772	    2.7966217362354251	    2.9097182301672486	    3.0257779713206920	    3.1776736639832044	    3.3934110195803653	    3.6255277010136346	    3.7948107325138798	    3.9766323244889046	    4.1539569999479218	    4.2042054429626647	    4.3115729386434420	    4.7224859046618093	;
   0.67166911392393835	   0.83313712776304538	   0.99429903536461262	    1.1545594421655712	    1.3130599534609642	    1.4040268663873838	    1.4721053220368479	    1.5773121614507895	    1.6471938327157583	    1.7364329649438548	    1.8516744245630290	    1.9436150719091982	    1.9783748664512644	    2.0989013388376199	    2.2265441782492577	    2.2692159783775474	    2.3777426725957262	    2.5141664352537627	    2.7049295793673194	    2.8759975159228190	    2.9921044017016505	    3.1112914038772663	    3.2672996172439945	    3.4888235844466866	    3.7218847562393220	    3.8942978711140133	    4.0791590611686459	    4.2591023582966123	    4.3100755552153780	    4.4189875644860344	    4.8370611533444778	;
   0.69954903971927695	   0.86545102367292315	    1.0309933065005794	    1.1954835553754286	    1.3579418121579696	    1.4510685909191894	    1.5207314289033329	    1.6283652940892033	    1.6999608930798000	    1.7917196440884633	    1.9120527509537670	    2.0056306141073983	    2.0407906257548256	    2.1621612938079822	    2.2908233337050374	    2.3339550140725436	    2.4432627023540272	    2.5805713384265978	    2.7731121825956278	    2.9481671051247349	    3.0670403553493357	    3.1890794205375133	    3.3488042328553602	    3.5754833990661528	    3.8126276068505551	    3.9850572322553877	    4.1722410567013029	    4.3542298499657832	    4.4057803540871623	    4.5159303361960887	    4.9393883248280908	;
   0.72593087190328898	   0.89633898392622458	    1.0663495133377481	    1.2352112387292395	    1.4018847005784991	    1.4973870766211168	    1.5688179135434206	    1.6791907825377355	    1.7526778733774708	    1.8470387678840108	    1.9717249043812570	    2.0674772755947703	    2.1030773630196715	    2.2247472427696513	    2.3536842191795424	    2.3971288978250884	    2.5074385974025519	    2.6460844640970280	    2.8399299717424191	    3.0189779992462591	    3.1405794903427022	    3.2654070087186473	    3.4287318340675252	    3.6603345826512292	    3.9023620390813174	    4.0743249679675371	    4.2634321608930321	    4.4471385407378943	    4.4991744682231944	    4.6103640319430674	    5.0380761884686187	;
   0.75565089578333910	   0.93159705802391013	    1.1071242603350377	    1.2814660752388387	    1.4536023659272270	    1.5522953776202557	    1.6261419359036577	    1.7403159955310590	    1.8163853224267150	    1.9140933617472842	    2.0430936274353741	    2.1411752026465170	    2.1772917281865438	    2.2994760796137030	    2.4281419219843956	    2.4717594539870378	    2.5832715852262416	    2.7243722011020819	    2.9187873022982229	    3.1026019083416001	    3.2273991708546390	    3.3554635686051646	    3.5229243352621635	    3.7600978740441287	    4.0076184999623941	    4.1799134138043845	    4.3708242631095997	    4.5561318363862160	    4.6086157841017004	    4.7207592840379711	    5.1521003796995277	;
   0.78181921436414192	   0.96314098341632615	    1.1440489310632667	    1.3238157885511490	    1.5015226495332661	    1.6035652059217038	    1.6799811251407961	    1.7982472889514567	    1.8770810905594231	    1.9782768734901917	    2.1112123952505857	    2.2111783752129726	    2.2477852278355237	    2.3707820633684356	    2.4991449923891151	    2.5427705242812024	    2.6549569885124460	    2.7994645450349354	    2.9924161790667818	    3.1805483665318715	    3.3082123799552856	    3.4391694613990351	    3.6102876090638487	    3.8523440177843011	    4.1047019839230758	    4.2782743241809875	    4.4703926325717260	    4.6567195505333281	    4.7094825928399695	    4.8222143675600764	    5.2555916420765216	;
   0.80320080676854122	   0.98926794117483818	    1.1749421303077121	    1.3595612157250574	    1.5423364485746540	    1.6474692605548920	    1.7262681674803215	    1.8483489521289425	    1.9297681921692400	    2.0342341160565356	    2.1708659411029485	    2.2726513226422123	    2.3097953732275238	    2.4338944920246992	    2.5624322624162597	    2.6061201616503773	    2.7187056884661036	    2.8664683113176590	    3.0612310807692227	    3.2474025787705134	    3.3773832732635607	    3.5106837276728990	    3.6847388367473615	    3.9307510765564615	    4.1870714726948357	    4.3625771912314804	    4.5552397610120119	    4.7421028725729064	    4.7950077994999862	    4.9080342496198597	    5.3423079877334114	;
   0.83015130155396466	    1.0227338625196623	    1.2149738731425670	    1.4063343766873706	    1.5962437190828105	    1.7057617987258409	    1.7879501550542984	    1.9154697408727877	    2.0005993362798353	    2.1098359208567827	    2.2522980196459637	    2.3572251350951441	    2.3952982285915043	    2.5216788429928738	    2.6519361093287594	    2.6961177046719773	    2.8097582688855183	    2.9614117629019590	    3.1628251542649153	    3.3455535959549336	    3.4725640943908438	    3.6055345712964773	    3.7831231650511805	    4.0340767272973670	    4.2954150806257534	    4.4742292642725960	    4.6673835009507822	    4.8544477539135533	    4.9073960845997675	    5.0205041232557042	    5.4548030767232962	;
   0.84974118835206092	    1.0474588349888971	    1.2448868259770034	    1.4416036938338890	    1.6372171651833247	    1.7502470543734974	    1.8351495193806993	    1.9670260532793649	    2.0551436033118167	    2.1682682184505513	    2.3157595215986144	    2.4240679826149862	    2.4632985633718154	    2.5932465964974232	    2.7256653919105323	    2.7707072500469709	    2.8865004687959677	    3.0403277036292553	    3.2458023486343031	    3.4296747785190638	    3.5563052551412153	    3.6877767998818927	    3.8618621345756909	    4.1126904918755089	    4.3776764113125344	    4.5595020125120262	    4.7526887899418275	    4.9395220231528381	    4.9923967904369091	    5.1053415403379860	    5.5388807174624830	;
   0.87563439094256068	    1.0806946397554831	    1.2855556763469074	    1.4899752201923406	    1.6938137603337640	    1.8119025099761306	    1.9007119029646651	    2.0388604532390451	    2.1312977771958099	    2.2500938833663802	    2.4052684868844620	    2.5196842791511096	    2.5612481106533984	    2.6992375113945255	    2.8359385843987583	    2.8823842025392565	    3.0022285198066871	    3.1593940683186714	    3.3674388076557378	    3.5510654875990033	    3.6759633911905825	    3.8059925572131443	    3.9794278162347370	    4.2311236553891476	    4.4965718755692148	    4.6781015099835148	    4.8706098530763144	    5.0596941433218783	    5.1132724351768211	    5.2277357269744469	    5.6676426174072105	;
   0.92206070038017884	    1.1432390417816538	    1.3644744804219451	    1.5859449887617989	    1.8079890827360396	    1.9372149727724826	    2.0346085150387232	    2.1865479918056114	    2.2886028840497761	    2.4203071362103055	    2.5941356253889878	    2.7242634396661023	    2.7717701338565597	    2.9303324059124889	    3.0871623995522235	    3.1388602380152504	    3.2684224550283836	    3.4305860001643049	    3.6338736283358739	    3.8106175860892302	    3.9316353857116617	    4.0584813720808937	    4.2297341349152111	    4.4816143100602712	    4.7432535230400541	    4.9208042035666884	    5.1087222759927293	    5.3016585561124803	    5.3567067330611904	    5.4743184262054028	    5.9266014892205048	;
   0.95401651506643248	    1.1884762137433620	    1.4232228208471274	    1.6587725252053622	    1.8958096465321146	    2.0341858929856134	    2.1386297757211423	    2.3018852165701413	    2.4117722311533991	    2.5537897909310572	    2.7412830831608326	    2.8808857927785825	    2.9316731981788946	    3.1004416880751524	    3.2682426957713280	    3.3236371607142865	    3.4624062021410982	    3.6316294287876141	    3.8383314751199729	    4.0172494174203406	    4.1390954342132789	    4.2656819469011964	    4.4352930344456922	    4.6847592272478975	    4.9368971848095526	    5.1085400495637749	    5.2909697654603409	    5.4841190474373427	    5.5401531093897169	    5.6598802033104372	    6.1205477216560453	;
   0.96609409928518930	    1.2057688717870083	    1.4458224730097751	    1.6869052070645247	    1.9298338956058088	    2.0717980203394939	    2.1789999113881526	    2.3466598379061572	    2.4595647502689508	    2.6055120456852356	    2.7980940480535801	    2.9411687238861566	    2.9931670643411343	    3.1657475877703227	    3.3372054586331061	    3.3937037574934781	    3.5353956134969629	    3.7081015284111780	    3.9166433272527255	    4.0971306737947968	    4.2195594865266397	    4.3463559867985992	    4.5155847843999615	    4.7632902987868659	    5.0117122138578409	    5.1811084969932848	    5.3613957435100463	    5.5544518839361814	    5.6108583728755752	    5.7313840499555821	    6.1952064317027027	;
    1.0227900785164266	    1.2889904643922196	    1.5560571812928035	    1.8253474883933691	    2.0983202342161480	    2.2584698315329774	    2.3795537182370574	    2.5690541728035776	    2.6965016202183034	    2.8608428867078857	    3.0761645710611671	    3.2346551705429856	    3.2920849368932572	    3.4820090521276641	    3.6701436618783316	    3.7323080237193120	    3.8885186270039842	    4.0763367469973826	    4.2989132458603621	    4.4895079729520173	    4.6161726175872273	    4.7447007609839469	    4.9107533791250866	    5.1417531413354682	    5.3774653829493628	    5.5377124530248523	    5.7078608199855010	    5.8988131424422807	    5.9569737945597252	    6.0812518519972194	    6.5597245785966063	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel;
engine.fuel.description =  'Estimated VW 1.5L TSI evo Concept 4 Engine test fuel derived from the Aachen paper'; 
engine.fuel.density_kgpL_15C =  0.74008883199999997; 
engine.fuel.energy_density_MJpkg =  42.52; 
engine.fuel.research_octane_number =  98; 
engine.fuel.alcohol_pct_vol =  0; 

% Idle Speed
engine.idle_target_speed_radps = class_REVS_dynamic_lookup;
engine.idle_target_speed_radps.axis_1.signal =  'eng_runtime_sec'; 
engine.idle_target_speed_radps.axis_1.breakpoints = [	     0.0000000000000000	    10.000000000000000		]; 
engine.idle_target_speed_radps.table = [	     68.067840827778852	    68.067840827778852		]; 

% Calibration Adjustment Factors
engine.variant =  'basic engine'; 
